<?php

  session_start();
  include('includes/connection.php');
  
  /////SAVE NEW USER
  if (isset($_POST['user'])) 
  {
    $name = $_POST['username'];
    $password = $_POST['password'];
    $confirmpassword = $_POST['confirmpassword'];
  
    // INSERT QUERY
    $sql = "INSERT INTO user_creation (user_name, user_password, user_confirmpassword) VALUES (?,?,?)"; 
    $stmt = $mysqli->prepare($sql);
    $rc = $stmt->bind_param('sss', $name, $password, $confirmpassword);
    $stmt->execute();
  }
  /////SAVE NEW USER

?>


  <!DOCTYPE html>
  <html>
  <meta http-equiv="content-type" content="text/html;charset=utf-8" />
  <?php include("includes/head.php"); ?>

  <body class="hold-transition login-page">
    <div class="login-box">
      <div class="login-logo">
        <p>PROGRAMERS INTERNATIONAL</p>
      </div>
   
      <div class="card">
        <div class="card-body login-card-body">
          <p class="login-box-msg">Create NewUser</p>

          <form method="post">
            <div class="input-group mb-3">
              <input type="text" name="username" id="username" class="form-control" Required placeholder="UserName *">
              <div class="input-group-append">
                <div class="input-group-text">
                  <span class="fas fa-envelope"></span>
                </div>
              </div>
            </div>

            <div class="input-group mb-3">
              <input type="password" name="password" id="password" class="form-control" Required placeholder="PassWord *">
              <div class="input-group-append">
                <div class="input-group-text">
                  <span class="fas fa-lock"></span>
                </div>
              </div>
            </div>
            
            <div class="input-group mb-3">
              <input type="password" name="confirmpassword" id="confirmpassword" class="form-control" Required placeholder="Confirm PassWord *">
              <div class="input-group-append">
                <div class="input-group-text">
                  <span class="fas fa-lock"></span>
                </div>
              </div>
            </div>
            

            <div class="row">
              <div class="col-4">
                <div class="icheck-primary">
                </div>
              </div>

              <div class="col-12.5">
                <button type="submit" name="user" class="btn btn-success">SUBMIT</button>
                <input type="reset" name="cancel" Value="CANCEL" class="btn btn-danger">
                <a href="login.php"  class="btn btn-warning">BACK</a>
              </div>
            </div>
          </form>
          
        </div>
      </div>
    </div>


    <script src="plugins/jquery/jquery.min.js"></script>
    <script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="dist/js/adminlte.min.js"></script>

    <!-- Password & Confirm Password Match -->
    <script>
        var password = document.getElementById("password") , 
            confirm_password = document.getElementById("confirmpassword");

        function validatePassword()
        {
            if(password.value != confirm_password.value) 
          {
            confirm_password.setCustomValidity("Passwords Don't Match");
          }
          else 
          {
            confirm_password.setCustomValidity('');
          }
        }

        password.onchange = validatePassword;
        confirm_password.onkeyup = validatePassword;
    </script>

  </body>

  </html>