<?php

  session_start();
  include('includes/connection.php');
  include('includes/checklogin.php');
  check_login();
  $userid = $_SESSION['loginid'];

// Only Use Update Process
  $db_editstatus = 0;
  $db_supplieridno = 0;
  $db_title = "";
  $db_suppliername = "";
  $db_suppliercode  = "";
  $db_itemname = "";
  $db_itemdescription  = "";
  $db_placeofsupply = "";
  $db_placeofpincode = "";
// Only Use Update Process

// SAVE SUPPLIER REGISTRATION
if (isset($_POST['add_new_supplier'])) 
{
    $idno = 0;
    $title = $_POST['title'];
    $suppliername = $_POST['supplier_name'];
    $suppliercode  = $_POST['supplier_code'];
    $itemname = $_POST['item_name'];
    $itemdescription  = $_POST['item_description'];
    $placeofsupply = $_POST['place_of_supply'];
    $placeofpincode = $_POST['place_of_pincode'];

// INSERT QUERY 
    $insert = "INSERT INTO `mst_supplier` (`title`, `supplier_name`, `supplier_code`, `item_name`, `item_description`, `place_of_supply`, `place_of_pincode`) VALUES (?,?,?,?,?,?,?)";
    $stmt = $mysqli->prepare($insert);
    $rc = $stmt->bind_param('ssssssi', $title, $suppliername, $suppliercode, $itemname, $itemdescription, $placeofsupply, $placeofpincode);
    $stmt->execute();
    if ($stmt) 
    {
       $success = "Supplier Created Successfully";
    } 
    else 
    {
       $err = "Please Try Again Or Try Later";
    }
// INSERT QUERY 

GOTOLOOP1:         

}
// SAVE SUPPLIER REGISTRATION

// MOVING SUPPLIER REGISTRATION
if (isset($_GET['edit_supplier_idno'])) 
{
    $db_editstatus = 1;
    $db_supplieridno = intval($_GET['edit_supplier_idno']); 
    $db_title = "";
    $db_suppliername = "";
    $db_suppliercode  = "";
    $db_itemname = "";
    $db_itemdescription  = "";
    $db_placeofsupply = "";
    $db_placeofpincode = "";

    $select = "SELECT * FROM `mst_supplier` WHERE supplier_idno = ?";
    $stmt = $mysqli->prepare($select);
    $stmt->bind_param('i', $db_supplieridno);
    $stmt->execute();
    $result = $stmt->get_result();
    while ($row = mysqli_fetch_array($result)) 
    {
        $db_title = $row['title'];
        $db_suppliername = $row['supplier_name'];
        $db_suppliercode  = $row['supplier_code'];
        $db_itemname = $row['item_name'];
        $db_itemdescription  = $row['item_description'];
        $db_placeofsupply = $row['place_of_supply'];
        $db_placeofpincode = $row['place_of_pincode'];
    }
}
// MOVING SUPPLIER REGISTRATION

// EDITING - UPDATING SUPPLIER REGISTRATION
if (isset($_POST['edit_old_supplier'])) 
{
    $db_editstatus = 0;
    $db_title = $_POST['title'];
    $db_suppliername = $_POST['supplier_name'];
    $db_suppliercode  = $_POST['supplier_code'];
    $db_itemname = $_POST['item_name'];
    $db_itemdescription  = $_POST['item_description'];
    $db_placeofsupply = $_POST['place_of_supply'];
    $db_placeofpincode = $_POST['place_of_pincode'];

    $update = "UPDATE `mst_supplier` SET title=?, supplier_name=?, supplier_code=?, item_name=?, item_description=?, place_of_supply=?, place_of_pincode=? WHERE supplier_idno=?";
    $stmt = $mysqli->prepare($update);
    $rc = $stmt->bind_param('sssssssi', $db_title, $db_suppliername, $db_suppliercode, $db_itemname, $db_itemdescription, $db_placeofsupply, $db_placeofpincode, $db_supplieridno);
    $stmt->execute();
    if ($stmt) 
    {
       $success = "Supplier Registration Updated Successfully";
    } 
    else 
    {
       $err = "Please Try Again Or Try Later";
    }

GOTOLOOP2:

}
// EDITING - UPDATING SUPPLIER REGISTRATION

?>


<!DOCTYPE html>
<html>
<meta http-equiv="content-type" content="text/html;charset=utf-8" />
<?php include("includes/head.php"); ?>

<style>
    .select2-selection 
    {
        height: 34px !important;
        border-color: #ced4da !important;
    }

    .panel 
    {
        padding: 30px;
        margin-bottom: 20px;
        background-color: #ffffff;
        background-color: #F5F5F5; 
        border: 1px; 
        border-radius: 4px;
        -webkit-box-shadow: 0 1px 1px rgba(0, 0, 0, 0.05);
        box-shadow: 0 1px 1px rgba(0, 0, 0, 0.05);
    }

    .panel-heading 
    {
        padding: 10px 15px;
        margin: -15px -15px 15px;
        font-size: 17.5px;
        font-weight: 500;
        background-color: #E6E6E6;
        background-color:#f5f5f5;

        border: 1px solid #dddddd;
        border-top-right-radius: 3px;
        border-top-left-radius: 3px;
    }

    .panel-footer 
    {
        padding: 10px 15px;
        margin: 15px -15px -15px;
        background-color: #f5f5f5;
        border-top: 1px solid #dddddd;
        border-bottom-right-radius: 3px;
        border-bottom-left-radius: 3px;
    }

    .panel-primary 
    {
        border-color: #428bca;
    }

    .panel-primary .panel-heading 
    {
        color: #ffffff;
        background-color: #428bca;
        border-color: #428bca;
    }
</style>


<body class="hold-transition sidebar-mini layout-fixed layout-navbar-fixed">
    <div class="wrapper">
        <!-- Navbar -->
        <?php include("includes/nav.php"); ?>
        <!-- /.navbar -->

        <!-- Main Sidebar Container -->
        <?php include("includes/sidebar.php"); ?>

        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6">
                            <h1>Supplier Registration</h1>
                        </div>
                        <div class="col-sm-6">
                            <ol class="breadcrumb float-sm-right">
                                <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                <li class="breadcrumb-item"><a href="supplier_registration_manage.php">Manage Supplier</a></li>
                                <li class="breadcrumb-item active">Add</li>
                            </ol>
                        </div>
                    </div>
                </div><!-- /.container-fluid -->
            </section>

            <!-- Main content -->
            <section class="content">
                <div class="container-fluid">
                    <div class="row">
                        <!-- left column -->
                        <div class="col-md-12">
                            <!-- general form elements -->
                            <div class="card card-purple">
                                <div class="card-header">
                                    <h3 class="card-title">Fill out all the required fields</h3>
                                </div>
                                <!-- form start -->

                                <!-- <div class="col-md-12"> -->

                                <form method="post" enctype="multipart/form-data" role="form" action="#">
                                    <div class="card-body">

                                        <!-- ///////////////////////////////////////////////////////////////////// -->
                                        <!-- START - Supplier -->

                                        <h3><i class="nav-icon fas fa-address-book"></i>&nbsp;&nbsp;Supplier</h3>
                                        <div class="panel panel-default">
                                            <div class="panel-body color-white border-orange form-group form-group-sm">

                                                <div class="row">
                                                    <div class=" col-md-6 form-group">
                                                        <label for="title">Title </label>
                                                        <select name="title" id="title" class="form-control">
                                                            <option value="title">Select Title</option>
                                                            <option <?php if ($db_title == 'Mr') {echo "selected";} else {echo "";} ?> value="Mr">Mr</option>
                                                            <option <?php if ($db_title == 'Mrs') {echo "selected";} else {echo "";} ?> value="Mrs">Mrs</option>
                                                            <option <?php if ($db_title == 'Ms') {echo "selected";} else {echo "";} ?> value="Ms">Ms</option>
                                                            <option <?php if ($db_title == 'Miss') {echo "selected";} else {echo "";} ?> value="Miss">Miss</option>
                                                            <option <?php if ($db_title == 'Dr') { echo "selected"; } else { echo "";} ?> value="Dr">Dr</option>
                                                        </select>
                                                    </div>

                                                    <div class="col-md-6 form-group">
                                                        <label for="supplier_name">Supplier Name</label>
                                                        <input type="text" name="supplier_name" class="form-control" id="supplier_name" value="<?php echo $db_suppliername ?>">
                                                        <input type="hidden" name="supplier_idno" class="form-control" id="supplier_idno" >
                                                    </div>

                                                    <div class="col-md-6 form-group">
                                                        <label for="supplier_code">Supplier Code</label>
                                                        <input type="text" name="supplier_code" class="form-control" id="supplier_code" value="<?php echo $db_suppliercode ?>">
                                                    </div>

                                                    <div class="col-md-6 form-group">
                                                        <label for="item_name">Item Name</label>
                                                        <input type="text" name="item_name" class="form-control" id="item_name" value="<?php echo $db_itemname ?>">
                                                    </div>

                                                    <div class="col-md-6 form-group">
                                                        <label for="item_description">Item Description</label>
                                                        <textarea type="text" name="item_description" class="form-control" id="item_description"><?php echo $db_itemdescription ?></textarea>
                                                    </div>

                                                    <div class="col-md-6 form-group">
                                                        <label for="place_of_supply">Place Of Supply</label>
                                                        <input type="text" name="place_of_supply" class="form-control" id="place_of_supply" value="<?php echo $db_placeofsupply ?>">
                                                    </div>

                                                    <div class="col-md-6 form-group">
                                                        <label for="place_of_pincode">Place Of Pincode</label>
                                                        <input type="text" name="place_of_pincode" class="form-control" id="place_of_pincode" value="<?php echo $db_placeofpincode ?>">
                                                    </div>
                                              
                                                  </div>
                                               </div>
                                            </div> 
                                            
                                            
                                    <div class="card-footer"> 
                                        <?php echo isset($db_editstatus) && $db_editstatus == 1 ?  '<button type="submit" name="edit_old_supplier" class="btn btn-success">EDIT</button>' :  '<button type="submit" name="add_new_supplier" class="btn btn-success">SAVE</button>' ?>
                                        <input type="reset" name="cancel" Value="CANCEL" class="btn btn-danger">
                                        <a href="customer_registration_manage.php" class="btn btn-warning">BACK</a>
                                    </div>
                                </form>
                            </div>
                            <!-- /.card -->
                        </div><!-- /.container-fluid -->
            </section> 
            <!-- /.content -->
        </div>
        
        <aside class="control-sidebar control-sidebar-dark">  </aside>
        <!-- /.control-sidebar -->

    </div>
    <!-- ./wrapper -->

    <!-- jQuery -->
    <script src="plugins/jquery/jquery.min.js"></script>
    <!-- Bootstrap 4 -->
    <script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
    <!-- bs-custom-file-input -->
    <script src="plugins/bs-custom-file-input/bs-custom-file-input.min.js"></script>
    <!-- AdminLTE App -->
    <script src="dist/js/adminlte.min.js"></script>
    <!-- AdminLTE for demo purposes -->
    <script src="dist/js/demo.js"></script>

</body>

</html>