<?php

  session_start();
  include('includes/connection.php');
  include('includes/checklogin.php');
  check_login();
  $userid = $_SESSION['loginid'];

/// Delete Product Record Registration
if (isset($_GET['delete_productrecord_idno'])) 
{
  $id = intval($_GET['delete_productrecord_idno']);
  $sql = "DELETE FROM `mst_product` WHERE productrecord_idno=?";
  $stmt = $mysqli->prepare($sql);
  $stmt->bind_param('i', $id);
  $stmt->execute();
  $stmt->close();
  if ($stmt) 
  {
    $info = "Product Record Deleted Successfully";
  } 
  else 
  {
    $err = "Try Again Later";
  }
  header('Product Record:productrecord_registration_manage.php');
}
/// Delete Product Record Registration

?>


<!DOCTYPE html>
<html>
<meta http-equiv="content-type" content="text/html;charset=utf-8" />
<?php include("includes/head.php"); ?>

<body class="hold-transition sidebar-mini">
  <div class="wrapper">
    <?php include("includes/nav.php"); ?>
    <?php include("includes/sidebar.php"); ?>

    <div class="content-wrapper">
      <section class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-4">
              <h1>Product Reorder</h1>
            </div>
            <div class="col-sm-2">
                <a class="btn btn-success btn-sm" href="productrecord_registration_add.php">
                    <i class='fas fa-plus'></i>
                    New Product Reorder
                </a>
            </div>            
            <div class="col-sm-6">
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="productrecord_registration_manage.php">Product Reorder</a></li>
                <li class="breadcrumb-item active">Manage Product Reorder</li>
              </ol>
            </div>
          </div>
        </div>
      </section>

      <section class="content">
        <div class="row">
          <div class="col-12">
            <div class="card">
              <div class="card-body">
                <table id="table1" class="table table-hover table-bordered table-striped">
                  <thead>
                    <tr>
                      <th>SI.No</th>
                      <th>Product Reorder Name</th>
                      <th hidden>Product Reorder IdNo</th>
                      <th>Product Reorder Value</th>
                      <th>Product Reorder Description</th>
                      <th Width="130">ACTION</th>
                    </tr>
                  </thead>

                <tbody>

                    <?php 
                    $ret = "SELECT * FROM `mst_product` WHERE productrecord_idno";
                    $stmt = $mysqli->prepare($ret);
                    $stmt->execute();
                    $res = $stmt->get_result();
                    $cnt = 1;
                    while ($row = $res->fetch_object()) 
                    {
                    ?>
                    <tr>
                        <td><?php echo $cnt; ?></td>
                        <td><?php echo $row->productrecord_name; ?></td>
                        <td hidden><?php echo $row->productrecord_idno; ?></td>                  
                        <td><?php echo $row->productrecord_value; ?></td>
                        <td><?php echo $row->productrecord_description; ?></td>
                      <td> 
                  
                        <a class="btn btn-success btn-sm" href="productrecord_registration_add.php?edit_productrecord_idno=<?php echo $row->productrecord_idno; ?>">
                           <i class='far fa-edit'></i>
                           Edit
                        </a>

                        <a class="btn btn-danger btn-sm" href="productrecord_registration_manage.php?delete_productrecord_idno=<?php echo $row->productrecord_idno; ?>"  title="Delete Record" onclick="return confirm('Do you want to delete');" >
                           <i class="fas fa-trash"></i>
                           Delete
                        </a> 

                    </td>         
                    </tr>         
                    
                    <?php $cnt = $cnt + 1;     
                    }   
                    ?>

                  </div>
                  </div>
                  </tfoot>
                </table>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>
    <?php include("includes/footer.php"); ?>
    <aside class="control-sidebar control-sidebar-dark"></aside>
  </div>


  <script src="plugins/jquery/jquery.min.js"></script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="plugins/datatables/jquery.dataTables.js"></script>
  <script src="plugins/datatables-bs4/js/dataTables.bootstrap4.js"></script>
  <script src="dist/js/adminlte.min.js"></script>
  <script src="dist/js/demo.js"></script>

  <script>
    $(function() 
    {
      $("#table1").DataTable();
      $('#table2').DataTable
      ({
        "paging": true,
        "lengthChange": false,
        "searching": false,
        "ordering": true,
        "info": true,
        "autoWidth": false,
      });
    });
  </script>

</body>
</html>
