<?php

  session_start();
  include('includes/connection.php');
  include('includes/checklogin.php');
  check_login();
  $userid = $_SESSION['loginid'];

// Only Use Update Process
  $db_editstatus = 0;
  $db_productrecordidno = 0;
  $db_productrecordname = "";
  $db_productrecordvalue = "";
  $db_productrecordpricelist = "";
  $db_productrecorddescription = "";
// Only Use Update Process

// SAVE PRODUCT RECORD REGISTRATION
if (isset($_POST['add_new_productrecord'])) 
{
    $idno = 0;
    $productrecordname = $_POST['productrecord_name'];
    $productrecordvalue = $_POST['productrecord_value'];
    $productrecordpricelist = $_POST['productrecord_pricelist'];
    $productrecorddescription = $_POST['productrecord_description'];

// INSERT QUERY 
    $insert = "INSERT INTO `mst_product` (`productrecord_name`, `productrecord_value`, `productrecord_pricelist`, `productrecord_description`) VALUES (?,?,?,?)";
    $stmt = $mysqli->prepare($insert);
    $rc = $stmt->bind_param('ssss', $productrecordname, $productrecordvalue, $productrecordpricelist, $productrecorddescription);
    $stmt->execute();
    if ($stmt) 
    {
       $success = "Product Reorder Created Successfully";
    } 
    else 
    {
       $err = "Please Try Again Or Try Later";
    }
// INSERT QUERY 

GOTOLOOP1:         

}
// SAVE PRODUCT RECORD REGISTRATION

// MOVING PRODUCT RECORD REGISTRATION
if (isset($_GET['edit_productrecord_idno'])) 
{
    $db_editstatus = 1;
    $db_productrecordidno = intval($_GET['edit_productrecord_idno']); 
    $db_productrecordname = "";
    $db_productrecordvalue = "";
    $db_productrecordpricelist = "";
    $db_productrecorddescription = "";

    $select = "SELECT * FROM `mst_product` WHERE productrecord_idno = ?";
    $stmt = $mysqli->prepare($select);
    $stmt->bind_param('i', $db_productrecordidno);
    $stmt->execute();
    $result = $stmt->get_result();
    while ($row = mysqli_fetch_array($result)) 
    {
        $db_productrecordname = $row ['productrecord_name'];
        $db_productrecordvalue = $row ['productrecord_value'];
        $db_productrecordpricelist = $row ['productrecord_pricelist'];
        $db_productrecorddescription = $row ['productrecord_description'];
    }
}
// MOVING PRODUCT RECORD REGISTRATION

// EDITING - UPDATING PRODUCT RECORD REGISTRATION
if (isset($_POST['edit_old_productrecord'])) 
{
    $db_editstatus = 0;
    $db_productrecordname = $_POST ['productrecord_name'];
    $db_productrecordvalue = $_POST ['productrecord_value'];
    $db_productrecordpricelist = $_POST['productrecord_pricelist'];
    $db_productrecorddescription = $_POST ['productrecord_description'];

    $update = "UPDATE `mst_product` SET productrecord_name=?, productrecord_value=?, productrecord_pricelist=?, productrecord_description=? WHERE productrecord_idno=?";
    $stmt = $mysqli->prepare($update);
    $rc = $stmt->bind_param('ssssi', $db_productrecordname, $db_productrecordvalue, $db_productrecordpricelist, $db_productrecorddescription, $db_productrecordidno);
    $stmt->execute();
    if ($stmt) 
    {
       $success = "Product Reorder Updated Successfully";
    } 
    else 
    {
       $err = "Please Try Again Or Try Later";
    }

GOTOLOOP2:

}
// EDITING - UPDATING PRODUCT RECORD REGISTRATION

?>


<!DOCTYPE html>
<html>
<meta http-equiv="content-type" content="text/html;charset=utf-8" />
<?php include("includes/head.php"); ?>

<style>
    .select2-selection 
    {
        height: 34px !important;
        border-color: #ced4da !important;
    }

    .panel 
    {
        padding: 30px;
        margin-bottom: 20px;
        background-color: #ffffff;
        background-color: #F5F5F5; 
        border: 1px; 
        border-radius: 4px;
        -webkit-box-shadow: 0 1px 1px rgba(0, 0, 0, 0.05);
        box-shadow: 0 1px 1px rgba(0, 0, 0, 0.05);
    }

    .panel-heading 
    {
        padding: 10px 15px;
        margin: -15px -15px 15px;
        font-size: 17.5px;
        font-weight: 500;
        background-color: #E6E6E6;
        background-color:#f5f5f5;

        border: 1px solid #dddddd;
        border-top-right-radius: 3px;
        border-top-left-radius: 3px;
    }

    .panel-footer 
    {
        padding: 10px 15px;
        margin: 15px -15px -15px;
        background-color: #f5f5f5;
        border-top: 1px solid #dddddd;
        border-bottom-right-radius: 3px;
        border-bottom-left-radius: 3px;
    }

    .panel-primary 
    {
        border-color: #428bca;
    }

    .panel-primary .panel-heading 
    {
        color: #ffffff;
        background-color: #428bca;
        border-color: #428bca;
    }
</style>


<body class="hold-transition sidebar-mini layout-fixed layout-navbar-fixed">
    <div class="wrapper">
        <!-- Navbar -->
        <?php include("includes/nav.php"); ?>
        <!-- /.navbar -->

        <!-- Main Sidebar Container -->
        <?php include("includes/sidebar.php"); ?>

        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6">
                            <h1>Product Reorder</h1>
                        </div>
                        <div class="col-sm-6">
                            <ol class="breadcrumb float-sm-right">
                                <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                <li class="breadcrumb-item"><a href="productrecord_registration_manage.php">Manage Product Reorder</a></li>
                                <li class="breadcrumb-item active">Add</li>
                            </ol>
                        </div>
                    </div>
                </div><!-- /.container-fluid -->
            </section>

            <!-- Main content -->
            <section class="content">
                <div class="container-fluid">
                    <div class="row">
                        <!-- left column -->
                        <div class="col-md-12">
                            <!-- general form elements -->
                            <div class="card card-purple">
                                <div class="card-header">
                                    <h3 class="card-title">Fill out all the required fields</h3>
                                </div>
                                <!-- form start -->

                                <!-- <div class="col-md-12"> -->

                                <form method="post" enctype="multipart/form-data" role="form" action="#">
                                    <div class="card-body">

                                        <!-- ///////////////////////////////////////////////////////////////////// -->
                                        <!-- START - Product Reorder -->

                                        <h3><i class="nav-icon fas fa-address-book"></i>&nbsp;&nbsp;Product Reorder</h3>
                                        <div class="panel panel-default">
                                            <div class="panel-body color-white border-orange form-group form-group-sm">

                                                <div class="row">                              
                                                    <div class="col-md-12 form-group">
                                                        <label for="productrecord_name">Product Reorder Name</label>
                                                        <input type="text" name="productrecord_name" class="form-control" id="productrecord_name" value="<?php echo $db_productrecordname ?>">
                                                        <input type="hidden" name="productrecord_idno" class="form-control" id="productrecord_idno" >
                                                    </div>

                                                    <div class="col-md-12 form-group">
                                                        <label for="productrecord_value">Product Reorder Value</label>
                                                        <input type="text" name="productrecord_value" class="form-control" id="productrecord_value" value="<?php echo $db_productrecordvalue ?>">
                                                    </div>

                                                    <div class="col-md-12 form-group">
                                                        <label for="productrecord_pricelist">Product Price List</label>
                                                        <input type="text" name="productrecord_pricelist" class="form-control" id="productrecord_pricelist" value="<?php echo $db_productrecordpricelist ?>">
                                                    </div>

                                                    <div class="col-md-12 form-group">
                                                        <label for="productrecord_description">Product Reorder Description</label>
                                                        <textarea type="text" name="productrecord_description" class="form-control" id="productrecord_description"><?php echo $db_productrecorddescription ?></textarea>
                                                    </div>
                                              
                                                  </div>
                                               </div>
                                            </div> 
                                            
                                            
                                    <div class="card-footer"> 
                                        <?php echo isset($db_editstatus) && $db_editstatus == 1 ?  '<button type="submit" name="edit_old_productrecord" class="btn btn-success">EDIT</button>' :  '<button type="submit" name="add_new_productrecord" class="btn btn-success">SAVE</button>' ?>
                                        <input type="reset" name="cancel" Value="CANCEL" class="btn btn-danger">
                                        <a href="customer_registration_manage.php" class="btn btn-warning">BACK</a>
                                    </div>
                                </form>
                            </div>
                            <!-- /.card -->
                        </div><!-- /.container-fluid -->
            </section> 
            <!-- /.content -->
        </div>
        
        <aside class="control-sidebar control-sidebar-dark">  </aside>
        <!-- /.control-sidebar -->

    </div>
    <!-- ./wrapper -->

    <!-- jQuery -->
    <script src="plugins/jquery/jquery.min.js"></script>
    <!-- Bootstrap 4 -->
    <script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
    <!-- bs-custom-file-input -->
    <script src="plugins/bs-custom-file-input/bs-custom-file-input.min.js"></script>
    <!-- AdminLTE App -->
    <script src="dist/js/adminlte.min.js"></script>
    <!-- AdminLTE for demo purposes -->
    <script src="dist/js/demo.js"></script>

</body>

</html>