<?php

  session_start();
  include('includes/connection.php');
  include('includes/checklogin.php');
  check_login();
  $userid = $_SESSION['loginid'];

// Only Use Update Process
  $db_editstatus = 0;
  $db_brandidno = 0;
  $db_brandname = "";
  $db_brandmodel = "";
  $db_brandspecification = "";
  $db_branddescription = "";
// Only Use Update Process

// SAVE NEW BRAND REGISTRATION
if (isset($_POST['add_new_brand'])) 
{
    $idno = 0;
    $brandname = $_POST ['brand_name'];
    $brandmodel = $_POST ['brand_model'];
    $brandspecification = $_POST ['brand_specification'];
    $branddescription = $_POST ['brand_description'];

// INSERT QUERY 
    $insert = "INSERT INTO `mst_brand` (`brand_name`, `brand_model`, `brand_specification`, `brand_description`) VALUES (?,?,?,?)";
    $stmt = $mysqli->prepare($insert);
    $rc = $stmt->bind_param('ssss', $brandname, $brandmodel, $brandspecification, $branddescription);
    $stmt->execute();
    if ($stmt) 
    {
       $success = "Brand Created Successfully";
    } 
    else 
    {
       $err = "Please Try Again Or Try Later";
    }
// INSERT QUERY 

GOTOLOOP1:         

}
// SAVE NEW BRAND REGISTRATION

// MOVING BRAND REGISTRATION
if (isset($_GET['edit_brand_idno'])) 
{
    $db_editstatus = 1;
    $db_brandidno = intval($_GET['edit_brand_idno']); 
    $db_brandname = "";
    $db_brandmodel = "";
    $db_brandspecification = "";
    $db_branddescription = "";

    $select = "SELECT * FROM `mst_brand` WHERE brand_idno = ?";
    $stmt = $mysqli->prepare($select);
    $stmt->bind_param('i', $db_brandidno);
    $stmt->execute();
    $result = $stmt->get_result();
    while ($row = mysqli_fetch_array($result)) 
    {
        $db_brandname = $row ['brand_name'];
        $db_brandmodel = $row ['brand_model'];
        $db_brandspecification = $row ['brand_specification'];
        $db_branddescription = $row ['brand_description'];
    }
}
// MOVING BRAND REGISTRATION

// EDITING - UPDATING BRAND REGISTRATION
if (isset($_POST['edit_old_brand'])) 
{
    $db_editstatus = 0;
    $db_brandname = $_POST ['brand_name'];
    $db_brandmodel = $_POST ['brand_model'];
    $db_brandspecification = $_POST ['brand_specification'];
    $db_branddescription = $_POST ['brand_description'];

    $update = "UPDATE `mst_brand` SET brand_name=?, brand_model=?, brand_specification=?, brand_description=? WHERE brand_idno=?";
    $stmt = $mysqli->prepare($update);
    $rc = $stmt->bind_param('ssssi', $db_brandname, $db_brandmodel, $db_brandspecification, $db_branddescription, $db_brandidno);
    $stmt->execute();
    if ($stmt) 
    {
       $success = "Brand Updated Successfully";
    } 
    else 
    {
       $err = "Please Try Again Or Try Later";
    }

GOTOLOOP2:

}
// EDITING - UPDATING BRAND REGISTRATION

?>


<!DOCTYPE html>
<html>
<meta http-equiv="content-type" content="text/html;charset=utf-8" />
<?php include("includes/head.php"); ?>

<style>
    .select2-selection 
    {
        height: 34px !important;
        border-color: #ced4da !important;
    }

    .panel 
    {
        padding: 30px;
        margin-bottom: 20px;
        background-color: #ffffff;
        background-color: #F5F5F5; 
        border: 1px; 
        border-radius: 4px;
        -webkit-box-shadow: 0 1px 1px rgba(0, 0, 0, 0.05);
        box-shadow: 0 1px 1px rgba(0, 0, 0, 0.05);
    }

    .panel-heading 
    {
        padding: 10px 15px;
        margin: -15px -15px 15px;
        font-size: 17.5px;
        font-weight: 500;
        background-color: #E6E6E6;
        background-color:#f5f5f5;

        border: 1px solid #dddddd;
        border-top-right-radius: 3px;
        border-top-left-radius: 3px;
    }

    .panel-footer 
    {
        padding: 10px 15px;
        margin: 15px -15px -15px;
        background-color: #f5f5f5;
        border-top: 1px solid #dddddd;
        border-bottom-right-radius: 3px;
        border-bottom-left-radius: 3px;
    }

    .panel-primary 
    {
        border-color: #428bca;
    }

    .panel-primary .panel-heading 
    {
        color: #ffffff;
        background-color: #428bca;
        border-color: #428bca;
    }
</style>


<body class="hold-transition sidebar-mini layout-fixed layout-navbar-fixed">
    <div class="wrapper">
        <!-- Navbar -->
        <?php include("includes/nav.php"); ?>
        <!-- /.navbar -->

        <!-- Main Sidebar Container -->
        <?php include("includes/sidebar.php"); ?>

        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6">
                            <h1>Product Record</h1>
                        </div>
                        <div class="col-sm-6">
                            <ol class="breadcrumb float-sm-right">
                                <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                <li class="breadcrumb-item"><a href="brand_registration_manage.php">Manage Brand</a></li>
                                <li class="breadcrumb-item active">Add</li>
                            </ol>
                        </div>
                    </div>
                </div><!-- /.container-fluid -->
            </section>

            <!-- Main content -->
            <section class="content">
                <div class="container-fluid">
                    <div class="row">
                        <!-- left column -->
                        <div class="col-md-12">
                            <!-- general form elements -->
                            <div class="card card-purple">
                                <div class="card-header">
                                    <h3 class="card-title">Fill out all the required fields</h3>
                                </div>
                                <!-- form start -->

                                <!-- <div class="col-md-12"> -->

                                <form method="post" enctype="multipart/form-data" role="form" action="#">
                                    <div class="card-body">

                                        <!-- ///////////////////////////////////////////////////////////////////// -->
                                        <!-- START - Brand -->

                                        <h3><i class="nav-icon fas fa-address-book"></i>&nbsp;&nbsp;Brand</h3>
                                        <div class="panel panel-default">
                                            <div class="panel-body color-white border-orange form-group form-group-sm">

                                                <div class="row">                              
                                                    <div class="col-md-12 form-group">
                                                        <label for="brand_name">Brand Name</label>
                                                        <input type="text" name="brand_name" class="form-control" id="brand_name" value="<?php echo $db_brandname ?>">
                                                        <input type="hidden" name="brand_idno" class="form-control" id="brand_idno" >
                                                    </div>

                                                    <div class="col-md-12 form-group">
                                                        <label for="brand_model">Brand Model</label>
                                                        <input type="text" name="brand_model" class="form-control" id="brand_model" value="<?php echo $db_brandmodel ?>">
                                                    </div>

                                                    <div class="col-md-12 form-group">
                                                        <label for="brand_specification">Brand Specification</label>
                                                        <input type="text" name="brand_specification" class="form-control" id="brand_specification" value="<?php echo $db_brandspecification ?>">
                                                    </div>

                                                    <div class="col-md-12 form-group">
                                                        <label for="brand_description">Brand Description</label>
                                                        <textarea type="text" name="brand_description" class="form-control" id="brand_description"><?php echo $db_branddescription ?></textarea>
                                                    </div>
                                              
                                                  </div>
                                               </div>
                                            </div> 
                                            
                                            
                                    <div class="card-footer"> 
                                        <?php echo isset($db_editstatus) && $db_editstatus == 1 ?  '<button type="submit" name="edit_old_brand" class="btn btn-success">EDIT</button>' :  '<button type="submit" name="add_new_brand" class="btn btn-success">SAVE</button>' ?>
                                        <input type="reset" name="cancel" Value="CANCEL" class="btn btn-danger">
                                        <a href="brand_registration_manage.php" class="btn btn-warning">BACK</a>
                                    </div>
                                </form>
                            </div>
                            <!-- /.card -->
                        </div><!-- /.container-fluid -->
            </section> 
            <!-- /.content -->
        </div>
        
        <aside class="control-sidebar control-sidebar-dark">  </aside>
        <!-- /.control-sidebar -->

    </div>
    <!-- ./wrapper -->

    <!-- jQuery -->
    <script src="plugins/jquery/jquery.min.js"></script>
    <!-- Bootstrap 4 -->
    <script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
    <!-- bs-custom-file-input -->
    <script src="plugins/bs-custom-file-input/bs-custom-file-input.min.js"></script>
    <!-- AdminLTE App -->
    <script src="dist/js/adminlte.min.js"></script>
    <!-- AdminLTE for demo purposes -->
    <script src="dist/js/demo.js"></script>

</body>

</html>